//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using System;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Injection
{

	/// <summary>
	/// Represents a factory for creating objects described by <see cref="NameTypeConfigurationElement"/> objects.
	/// </summary>
	/// <typeparam name="TObjectToCreate">The type of object to create.</typeparam>
	/// <typeparam name="TObjectConfiguration">The configuraiton object for the object to create. This object must be derived from <see cref="NameTypeConfigurationElement"/>.</typeparam>
	public abstract class NameTypeNamedObjectInjectionFactory<TObjectToCreate, TObjectConfiguration> : NamedObjectInjectionFactory<TObjectToCreate, TObjectConfiguration>
		where TObjectConfiguration : NameTypeConfigurationElement
	{
        protected override TObjectToCreate Create(TObjectConfiguration objectConfiguration, IConfigurationSource configurationSource)
        {
            return new InnerFactory<TObjectToCreate, TObjectConfiguration>().Create(objectConfiguration, configurationSource);         
        }

        private class InnerFactory<TInnerObjectToCreate, TInnerObjectConfiguration> : InjectionFactory<TInnerObjectToCreate, TInnerObjectConfiguration>
            where TInnerObjectConfiguration : NameTypeConfigurationElement
        {
            protected override Type GetObjectType(TInnerObjectConfiguration objectConfiguration, IConfigurationSource configurationSource)
            {
                return objectConfiguration.Type;
            }
        }
	}
}
